/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/
 package cnrg.itx.datax;

import java.util.Vector;

/**
 * Class to implement a channel property. This contains some information about
 * the channel and the devices that are attached to it.
 */
public class ChannelProperty
{	
	/**
	 * The list of device properties.
	 */
	private PropertiesCollection deviceProperties;
	
	/**
	 * Number of output devices in the channel.
	 */
	private int numOutputDevices;

	/**
	 * Type of the channel.
	 */
	private int channelType;

	/**
	 * Constructor for the channel property object.
	 * @param channelType the type of the channel(INPUT/OUTPUT)
	 */
	public ChannelProperty (int channelType)
	{
		this.channelType = channelType;
		numOutputDevices = 0;
		deviceProperties = new PropertiesCollection (channelType);
	}
	
	/**
	 * Method to add a device property to the channel property.
	 * @param deviceProperty the device property to add
	 */
	public void addProperty (Property deviceProperty)
	{
		deviceProperties.addProperty (deviceProperty);
	}
	
	/**
	 * Method to get the number of output devices attached to this channel.
	 * @return int the number of output devices attached to this channel
	 */
	public int getNumOutputDevices ()
	{
		return numOutputDevices;	
	}
	
	/**
	 * Method to return the type of the channel
	 * @return int the type of the channel
	 */
	public int getChannelType ()
	{
		return channelType;
	}
}